/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserAgentParser {
    private static final Pattern BROWSER_NAME_AND_VERSION = Pattern.compile("(Safari|Firefox|Konqueror)/([0-9\\.]+)");
    private static final Pattern CHROME_VERSION = Pattern.compile("Chrome/([0-9\\.]+)");
    private static final Pattern MSIE_VERSION = Pattern.compile("; MSIE ([0-9\\.]+);");
    private static final Pattern OPERA_VERSION = Pattern.compile("Opera(?:.*Version)?[ /]([0-9\\.]+)");
    private String userAgentName = "";
    private String userAgentVersion = "";
    private String userAgentOs = "";

    public void parse(String userAgent) {
        String lowerCaseUserAgent = userAgent.toLowerCase();
        if (lowerCaseUserAgent.contains("windows")) {
            this.userAgentOs = "Windows";
        } else if (lowerCaseUserAgent.contains("android")) {
            this.userAgentOs = "Android";
        } else if (lowerCaseUserAgent.contains("linux")) {
            this.userAgentOs = "Linux";
        } else if (lowerCaseUserAgent.contains("iphone")) {
            this.userAgentOs = "iPhone OS";
        } else if (lowerCaseUserAgent.contains("mac")) {
            this.userAgentOs = "Mac OS";
        }
        if (userAgent.contains("Chrome")) {
            this.userAgentName = "Chrome";
            Matcher matcher = CHROME_VERSION.matcher(userAgent);
            if (matcher.find()) {
                this.userAgentVersion = matcher.group(1);
            }
        } else if (userAgent.contains("MSIE")) {
            this.userAgentName = "Microsoft Internet Explorer";
            Matcher matcher = MSIE_VERSION.matcher(userAgent);
            if (matcher.find()) {
                this.userAgentVersion = matcher.group(1);
            }
        } else if (userAgent.contains("Opera")) {
            this.userAgentName = "Opera";
            Matcher matcher = OPERA_VERSION.matcher(userAgent);
            if (matcher.find()) {
                this.userAgentVersion = matcher.group(1);
            }
        } else if (userAgent.contains("Opera")) {
            this.userAgentName = "Opera";
            Matcher matcher = OPERA_VERSION.matcher(userAgent);
            if (matcher.find()) {
                this.userAgentVersion = matcher.group(1);
            }
        } else {
            Matcher matcher = BROWSER_NAME_AND_VERSION.matcher(userAgent);
            if (matcher.find()) {
                this.userAgentName = matcher.group(1);
                this.userAgentVersion = matcher.group(2);
            } else {
                this.userAgentName = userAgent;
            }
        }
    }

    public String getName() {
        return this.userAgentName;
    }

    public String getVersion() {
        return this.userAgentVersion;
    }

    public String getOs() {
        return this.userAgentOs;
    }
}

